#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));

struct vt
{
	double x, y;
	vt (double _x, double _y)
	{
		x = _x, y = _y;
	}
	vt(){}
};

const int N = 1 << 17;

int pt = 0;
vt S[N];
int Si[N];

double X[N], R[N];

double sqr(double x)
{
	return x * x;
}

vt inter(int i, int j)
{
	assert(i < j);
	assert(X[i] - X[j] < R[i] + R[j] + eps);
	double x = (sqr(R[i]) - sqr(R[j]) + sqr(X[j]) - sqr(X[i])) / (2 * (X[j] - X[i]));
	assert(sqr(R[i]) - sqr(x - X[i]) > -eps);
	double y1 = sqrt(max(0.0, sqr(R[i]) - sqr(x - X[i])));
	double y2 = sqrt(max(0.0, sqr(R[j]) - sqr(x - X[j])));
	assert(abs(y1 - y2) < 0.001);
	return vt(x, (y1 + y2) / 2.0);
}

bool in(int i, vt v)
{
	return sqr(v.x - X[i]) + sqr(v.y) < sqr(R[i]) + eps;
}

double T[2 * N];

double get(int l, int r)
{
	l += N;
	r += N;
	double ans = 1e9;
	while (l <= r)
	{
		if (l & 1)
			ans = min(ans, T[l]);
		if (!(r & 1))
			ans = min(ans, T[r]);
		l = (l + 1) / 2;
		r = (r - 1) / 2;
	}
	return ans;
}

double left_a(int i)
{
	return 2 * max(0.0, S[i].x - X[Si[i - 1]]);
}

double right_a(int i)
{
	return 2 * max(0.0, X[Si[i]] - S[i].x);
}



bool can(double d)
{
	int l = 0;
	int r = 0;
	while (l != pt - 1)
	{
		r = l + 1;
		while (S[r].y > d / 2)
			r++;
		if (l + 1 != r)
		{
			if (S[r - 1].x - S[l + 1].x + left_a(l + 1) + right_a(r - 1) > d)
				return true;
		}
		l = r;
	}

	return false;
}

inline bool solve() {
	int n;
	scanf("%d", &n);
	if (n == 0)
		return false;
	for (int i = 0; i < n; i++)
		scanf("%lf %lf", &X[i], &R[i]);
	pt = 0;
	S[pt++] = vt(X[0] - R[0], 0);
	S[pt++] = vt(X[0] + R[0], 0);
	Si[0] = 0;
	for (int i = 1; i < n; i++)
	{
		while (true)
		{
			assert(pt > 0);
			vt u = S[pt - 1];
			if (in(i, u))
				--pt;
			else
			{
				vt v = inter(Si[pt - 1], i);
				Si[pt] = i;
				vt u = vt(X[i] + R[i], 0);
				S[pt++] = v;
				S[pt++] = u;
				break;
			}
		}
	}
	for (int i = 0; i < pt; i++)
		eprintf("(%lf %lf) ", S[i].x, S[i].y);
	eprintf("\n");

	for (int i = 0; i < pt; i++)
		T[N + i] = S[i].y;
	for (int i = N - 1; i > 0; i--)
		T[i] = min(T[2 * i], T[2 * i + 1]);

	double sing = 0;
	for (int i = 0; i < n; i++)
		sing = max(sing, R[i] * sqrt(2.0));

	double l = 0, r = 1e6;
	for (int it = 0; it < 60; it++)
	{
		double m = (l + r) / 2;
		if (can(m))
			l = m;
		else
			r = m;
	}
	double ans = max((l + r) / 2, sing);
	printf("%.10lf\n", ans);
	return true;
}

int main() {
#ifdef LOCAL42
#define TASK "E"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	while (solve());
	return 0;
}
